/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.StringBufferInputStream;
import jclass.bwt.JCContainer;
import jclass.bwt.JCSerializable;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.EventTrigger;
import jclass.chart.InputStreamDataSource;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartStyle;
import jclass.chart.JCLegend;
import jclass.chart.JCLineStyle;
import jclass.chart.JCTitle;
import jclass.chart.JCValueLabel;
import jclass.chart.URLDataSource;
import jclass.util.JCConverter;

class ChartConverter {
    static final String[] anchor_strings = new String[]{"NORTHEAST", "NORTH", "NORTHWEST", "EAST", "WEST", "SOUTHEAST", "SOUTH", "SOUTHWEST"};
    static final int[] anchor_values = new int[]{17, 16, 18, 1, 2, 33, 32, 34};
    static final String[] border_strings = new String[]{"NONE", "ETCHED_IN", "ETCHED_OUT", "IN", "OUT", "PLAIN", "FRAME_IN", "FRAME_OUT"};
    static final int[] border_values = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    static final String[] orientation_strings = new String[]{"HORIZONTAL", "VERTICAL"};
    static final int[] orientation_values = new int[]{0, 1};
    static final String[] originPlacement_strings = new String[]{"AUTOMATIC", "ZERO", "MIN", "MAX"};
    static final int[] originPlacement_values = new int[]{0, 3, 1, 2};
    static final String[] shape_strings = new String[]{"NONE", "DOT", "BOX", "TRIANGLE", "DIAMOND", "STAR", "VERT_LINE", "HORIZ_LINE", "CROSS", "CIRCLE", "SQUARE"};
    static final int[] shape_values = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    static final String[] adjust_strings = new String[]{"LEFT", "CENTER", "RIGHT"};
    static final int[] adjust_values = new int[]{0, 1, 2};
    static final String[] chartType_strings = new String[]{"PLOT", "SCATTER_PLOT", "BAR", "STACKING_BAR", "PIE"};
    static final int[] chartType_values = new int[]{0, 1, 9, 10, 11};
    static final String[] rotation_strings = new String[]{"0", "90", "180", "270"};
    static final int[] rotation_values = new int[]{0, 1, 2, 3};
    static final String[] annRotation_strings = new String[]{"NONE", "90", "270"};
    static final int[] annRotation_values = new int[]{0, 1, 3};
    static final String[] annotationMethod_strings = new String[]{"VALUE", "VALUE_LABELS", "TIME_LABELS", "POINT_LABELS"};
    static final int[] annotationMethod_values = new int[]{0, 1, 2, 3};
    static final String[] eventMod_strings = new String[]{"SHIFT", "CTRL", "ALT", "NONE"};
    static final int[] eventMod_values = new int[]{1, 2, 8, 0};
    static final String[] placement_strings = new String[]{"AUTOMATIC", "ORIGIN", "MIN", "MAX", "VALUE_ANCHORED"};
    static final int[] placement_values = new int[]{0, 5, 1, 2, 4};
    static final String[] timeUnit_strings = new String[]{"SECONDS", "MINUTES", "HOURS", "DAYS", "WEEKS", "MONTHS", "YEARS"};
    static final long[] timeUnit_values = new long[]{1000L, 60000L, 3600000L, 86400000L, 604800000L, 2678400000L, 31536000000L};
    static final String[] fillPattern_strings = new String[]{"NONE", "SOLID", "PER_25", "PER_50", "PER_75", "HORIZ_STRIPE", "VERT_STRIPE", "STRIPE_45", "STRIPE_135", "DIAG_HATCHED", "CROSS_HATCHED"};
    static final int[] fillPattern_values = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    static final String[] linePattern_strings = new String[]{"NONE", "SOLID", "LONG_DASH", "SHORT_DASH", "LSL_DASH", "DASH_DOT"};
    static final int[] linePattern_values = new int[]{0, 1, 2, 3, 4, 5};
    static final String[] angleUnit_strings = new String[]{"DEGREES", "RADIANS", "GRADS"};
    static final int[] angleUnit_values = new int[]{1, 2, 3};
    static JCConverter conv;

    static void getParams(JCChart jCChart) {
        JCSerializable jCSerializable;
        EventTrigger eventTrigger;
        conv = JCContainer.getConverter();
        ChartDataView chartDataView = jCChart.getDataView(0);
        InputStreamDataSource inputStreamDataSource = null;
        String string = jCChart.getParam("data");
        if (string == null) {
            string = jCChart.getParam("dataFile");
            if (string == null) {
                System.err.println("no data or dataFile parameter");
            } else {
                try {
                    inputStreamDataSource = new URLDataSource(jCChart.getApplet().getDocumentBase(), string);
                }
                catch (Exception exception) {
                    System.err.println("Error reading in 'dataFile' parameter");
                    inputStreamDataSource = null;
                }
            }
        } else {
            try {
                inputStreamDataSource = new InputStreamDataSource(new StringBufferInputStream(string));
            }
            catch (Exception exception) {
                System.err.println("Error reading in 'data' parameter");
                inputStreamDataSource = null;
            }
        }
        if (inputStreamDataSource == null) {
            System.err.println("no data source!");
        } else {
            chartDataView.setDataSource(inputStreamDataSource);
        }
        String string2 = jCChart.getParam("rotateTrigger");
        if (string2 != null) {
            eventTrigger = jCChart.addTrigger();
            eventTrigger.setModifiers(conv.toEnum(string2, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(0);
        }
        if ((string2 = jCChart.getParam("zoomTrigger")) != null) {
            eventTrigger = jCChart.addTrigger();
            eventTrigger.setModifiers(conv.toEnum(string2, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(1);
        }
        if ((string2 = jCChart.getParam("translateTrigger")) != null) {
            eventTrigger = jCChart.addTrigger();
            eventTrigger.setModifiers(conv.toEnum(string2, "rotate trigger", eventMod_strings, eventMod_values, 0));
            eventTrigger.setAction(2);
        }
        chartDataView.setIsInverted(conv.toBoolean(jCChart.getParam("data.isInverted"), chartDataView.getIsInverted()));
        chartDataView.setChartType(conv.toEnum(jCChart.getParam("data.chartType"), "chart type", chartType_strings, chartType_values, chartDataView.getChartType()));
        chartDataView.setIsShowingInLegend(conv.toBoolean(jCChart.getParam("data.isShowingInLegend"), chartDataView.getIsShowingInLegend()));
        String string3 = jCChart.getParam("data.pointLabels");
        if (string3 != null) {
            chartDataView.setPointLabels(JCConverter.toStringList(string3));
        }
        int n = 0;
        while (n < chartDataView.getNumSeries()) {
            jCSerializable = chartDataView.getSeries(n);
            ChartConverter.getSeriesParams(jCChart, jCSerializable, "data.series" + (n + 1));
            ++n;
        }
        ChartConverter.getTitleParams(jCChart, jCChart.getHeader(), "header");
        ChartConverter.getTitleParams(jCChart, jCChart.getFooter(), "footer");
        ChartConverter.getLegendParams(jCChart, jCChart.getLegend(), "legend");
        ChartConverter.getChartAreaParams(jCChart, jCChart.getChartArea(), "chartArea");
        jCSerializable = chartDataView.getXAxis();
        JCAxis jCAxis = chartDataView.getYAxis();
        ChartConverter.getAxisParams(jCChart, (JCAxis)jCSerializable, "xaxis");
        ChartConverter.getAxisParams(jCChart, jCAxis, "yaxis");
    }

    static void getTitleParams(JCChart jCChart, JCTitle jCTitle, String string) {
        jCTitle.getLabel().setText(jCChart.getParam(String.valueOf(string) + ".text"), true);
        jCTitle.setFont(conv.toFont(jCChart.getParam(String.valueOf(string) + ".font"), jCTitle.getFont()));
        jCTitle.setBackground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".background"), jCTitle.getBackground()));
        jCTitle.setForeground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".foreground"), jCTitle.getForeground()));
        jCTitle.setIsShowing(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), jCTitle.getIsShowing()));
        jCTitle.setBorderType(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".borderType"), String.valueOf(string) + " border type", border_strings, border_values, jCTitle.getBorderType()));
        jCTitle.setBorderWidth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".borderWidth"), jCTitle.getBorderWidth()));
        if (jCChart.getParam(String.valueOf(string) + ".top") != null) {
            jCTitle.setTop(conv.toInt(jCChart.getParam(String.valueOf(string) + ".top"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".left") != null) {
            jCTitle.setLeft(conv.toInt(jCChart.getParam(String.valueOf(string) + ".left"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".width") != null) {
            jCTitle.setWidth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".width"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".height") != null) {
            jCTitle.setHeight(conv.toInt(jCChart.getParam(String.valueOf(string) + ".height"), 0));
        }
    }

    static void getLegendParams(JCChart jCChart, JCLegend jCLegend, String string) {
        jCLegend.setFont(conv.toFont(jCChart.getParam(String.valueOf(string) + ".font"), jCLegend.getFont()));
        jCLegend.setBackground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".background"), jCLegend.getBackground()));
        jCLegend.setForeground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".foreground"), jCLegend.getForeground()));
        jCLegend.setAnchor(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".anchor"), "legend anchor", anchor_strings, anchor_values, jCLegend.getAnchor()));
        jCLegend.setOrientation(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".orientation"), "legend orientation", orientation_strings, orientation_values, jCLegend.getOrientation()));
        jCLegend.setIsShowing(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), jCLegend.getIsShowing()));
        jCLegend.setBorderType(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".borderType"), String.valueOf(string) + " border type", border_strings, border_values, jCLegend.getBorderType()));
        jCLegend.setBorderWidth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".borderWidth"), jCLegend.getBorderWidth()));
        if (jCChart.getParam(String.valueOf(string) + ".top") != null) {
            jCLegend.setTop(conv.toInt(jCChart.getParam(String.valueOf(string) + ".top"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".left") != null) {
            jCLegend.setLeft(conv.toInt(jCChart.getParam(String.valueOf(string) + ".left"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".width") != null) {
            jCLegend.setWidth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".width"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".height") != null) {
            jCLegend.setHeight(conv.toInt(jCChart.getParam(String.valueOf(string) + ".height"), 0));
        }
    }

    static void getChartAreaParams(JCChart jCChart, JCChartArea jCChartArea, String string) {
        jCChartArea.setBackground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".background"), jCChartArea.getBackground()));
        jCChartArea.setForeground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".foreground"), jCChartArea.getForeground()));
        jCChartArea.setIsShowing(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), jCChartArea.getIsShowing()));
        jCChartArea.setBorderType(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".borderType"), String.valueOf(string) + " border type", border_strings, border_values, jCChartArea.getBorderType()));
        jCChartArea.setBorderWidth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".borderWidth"), jCChartArea.getBorderWidth()));
        jCChartArea.setAxisBoundingBox(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".axisBoundingBox"), jCChartArea.getAxisBoundingBox()));
        jCChartArea.getPlotArea().setForeground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".plotArea.foreground"), jCChartArea.getPlotArea().getForeground()));
        jCChartArea.getPlotArea().setBackground(conv.toColor(jCChart.getParam(String.valueOf(string) + ".plotArea.background"), jCChartArea.getPlotArea().getBackground()));
        jCChartArea.getPlotArea().setLeft(conv.toInt(jCChart.getParam(String.valueOf(string) + ".plotArea.left"), jCChartArea.getPlotArea().getLeft()));
        jCChartArea.getPlotArea().setRight(conv.toInt(jCChart.getParam(String.valueOf(string) + ".plotArea.right"), jCChartArea.getPlotArea().getRight()));
        jCChartArea.getPlotArea().setTop(conv.toInt(jCChart.getParam(String.valueOf(string) + ".plotArea.top"), jCChartArea.getPlotArea().getTop()));
        jCChartArea.getPlotArea().setBottom(conv.toInt(jCChart.getParam(String.valueOf(string) + ".plotArea.bottom"), jCChartArea.getPlotArea().getBottom()));
        jCChartArea.setDepth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".depth"), jCChartArea.getDepth()));
        jCChartArea.setElevation(conv.toInt(jCChart.getParam(String.valueOf(string) + ".elevation"), jCChartArea.getElevation()));
        jCChartArea.setRotation(conv.toInt(jCChart.getParam(String.valueOf(string) + ".rotation"), jCChartArea.getRotation()));
        jCChartArea.setAngleUnit(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".angleUnit"), String.valueOf(string) + " angle unit", angleUnit_strings, angleUnit_values, jCChartArea.getAngleUnit()));
        jCChartArea.setFastAction(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".fastAction"), jCChartArea.getFastAction()));
        if (jCChart.getParam(String.valueOf(string) + ".top") != null) {
            jCChartArea.setTop(conv.toInt(jCChart.getParam(String.valueOf(string) + ".top"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".left") != null) {
            jCChartArea.setLeft(conv.toInt(jCChart.getParam(String.valueOf(string) + ".left"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".width") != null) {
            jCChartArea.setWidth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".width"), 0));
        }
        if (jCChart.getParam(String.valueOf(string) + ".height") != null) {
            jCChartArea.setHeight(conv.toInt(jCChart.getParam(String.valueOf(string) + ".height"), 0));
        }
    }

    static void getAxisParams(JCChart jCChart, JCAxis jCAxis, String string) {
        jCAxis.setIsShowing(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), jCAxis.getIsShowing()));
        jCAxis.setIsLogarithmic(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isLogarithmic"), jCAxis.getIsLogarithmic()));
        jCAxis.setAnnotationRotation(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".annotationRotation"), String.valueOf(string) + " annotation rotation", annRotation_strings, annRotation_values, jCAxis.getAnnotationRotation()));
        jCAxis.setAnnotationMethod(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".annotationMethod"), String.valueOf(string) + " annotation method", annotationMethod_strings, annotationMethod_values, jCAxis.getAnnotationMethod()));
        jCAxis.setPlacement(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".placement"), String.valueOf(string) + " placement", placement_strings, placement_values, jCAxis.getPlacement()));
        jCAxis.setPlacementLocation(conv.toDouble(jCChart.getParam(String.valueOf(string) + ".placementLocation"), jCAxis.getPlacementLocation()));
        jCAxis.setTimeBase(conv.toDate(jCChart.getParam(String.valueOf(string) + ".timeBase"), jCAxis.getTimeBase()));
        jCAxis.setTimeUnit(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".timeUnit"), String.valueOf(string) + " time unit", timeUnit_strings, timeUnit_values, jCAxis.getTimeUnit()));
        String string2 = jCChart.getParam(String.valueOf(string) + ".timeFormat");
        if (string2 != null) {
            jCAxis.setTimeFormat(string2);
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".min")) != null) {
            jCAxis.setMin(conv.toDouble(string2, jCAxis.getMin()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".max")) != null) {
            jCAxis.setMax(conv.toDouble(string2, jCAxis.getMax()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".precision")) != null) {
            jCAxis.setPrecision(conv.toInt(string2, jCAxis.getPrecision()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".tickSpacing")) != null) {
            jCAxis.setTickSpacing(conv.toDouble(string2, jCAxis.getTickSpacing()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".numSpacing")) != null) {
            jCAxis.setNumSpacing(conv.toDouble(string2, jCAxis.getNumSpacing()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".origin")) != null) {
            jCAxis.setOrigin(conv.toDouble(string2, jCAxis.getOrigin()));
        }
        jCAxis.setOriginPlacement(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".originPlacement"), String.valueOf(string) + " origin placement", originPlacement_strings, originPlacement_values, jCAxis.getOriginPlacement()));
        JCAxisTitle jCAxisTitle = jCAxis.getTitle();
        if (jCAxisTitle == null) {
            jCAxisTitle = new JCAxisTitle();
            jCAxis.setTitle(jCAxisTitle);
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".title.text")) != null) {
            jCAxisTitle.setText(string2, true);
        }
        jCAxisTitle.setPlacement(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".title.placement"), String.valueOf(string) + " title placement", anchor_strings, anchor_values, jCAxisTitle.getPlacement()));
        jCAxisTitle.setAdjust(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".title.adjust"), String.valueOf(string) + " title adjust", adjust_strings, adjust_values, jCAxisTitle.getAdjust()));
        jCAxisTitle.setRotation(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".title.rotation"), String.valueOf(string) + " title rotation", rotation_strings, rotation_values, jCAxisTitle.getRotation()));
        jCAxis.setGridIsShowing(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".gridIsShowing"), jCAxis.getGridIsShowing()));
        string2 = jCChart.getParam(String.valueOf(string) + ".gridSpacing");
        if (string2 != null) {
            jCAxis.setGridSpacing(conv.toDouble(string2, jCAxis.getGridSpacing()));
        }
        JCLineStyle jCLineStyle = jCAxis.getGridStyle().getLineStyle();
        jCLineStyle.setColor(conv.toColor(jCChart.getParam(String.valueOf(string) + ".gridColor"), jCLineStyle.getColor()));
        string2 = jCChart.getParam(String.valueOf(string) + ".valueLabels");
        if (string2 != null) {
            String[] stringArray = JCConverter.toStringList(string2);
            int n = 0;
            while (n < stringArray.length) {
                jCAxis.addValueLabel(new JCValueLabel(conv.toDouble(stringArray[n], 0.0), stringArray[n + 1]));
                n += 2;
            }
        }
        jCAxis.setIsEditable(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isEditable"), jCAxis.getIsEditable()));
    }

    static void getSeriesParams(JCChart jCChart, ChartDataViewSeries chartDataViewSeries, String string) {
        JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
        jCChartStyle.setLineColor(conv.toColor(jCChart.getParam(String.valueOf(string) + ".line.color"), jCChartStyle.getLineColor()));
        jCChartStyle.setLineWidth(conv.toInt(jCChart.getParam(String.valueOf(string) + ".line.width"), jCChartStyle.getLineWidth()));
        jCChartStyle.setSymbolColor(conv.toColor(jCChart.getParam(String.valueOf(string) + ".symbol.color"), jCChartStyle.getSymbolColor()));
        jCChartStyle.setSymbolShape(conv.toEnum(jCChart.getParam(String.valueOf(string) + ".symbol.shape"), String.valueOf(string) + " symbol shape", shape_strings, shape_values, jCChartStyle.getSymbolShape()));
        jCChartStyle.setSymbolSize(conv.toInt(jCChart.getParam(String.valueOf(string) + ".symbol.size"), jCChartStyle.getSymbolSize()));
        jCChartStyle.setFillColor(conv.toColor(jCChart.getParam(String.valueOf(string) + ".fill.color"), jCChartStyle.getFillColor()));
        jCChartStyle.setFillImage(conv.toImage(jCChart, jCChart.getParam(String.valueOf(string) + ".fill.image"), jCChartStyle.getFillImage()));
        chartDataViewSeries.setIsShowing(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), chartDataViewSeries.getIsShowing()));
        chartDataViewSeries.setIsIncluded(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isIncluded"), chartDataViewSeries.getIsIncluded()));
        chartDataViewSeries.setIsShowingInLegend(conv.toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowingInLegend"), chartDataViewSeries.getIsShowingInLegend()));
        String string2 = jCChart.getParam(String.valueOf(string) + ".firstPoint");
        if (string2 != null) {
            chartDataViewSeries.setFirstPoint(conv.toInt(string2, chartDataViewSeries.getFirstPoint()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".lastPoint")) != null) {
            chartDataViewSeries.setLastPoint(conv.toInt(string2, chartDataViewSeries.getLastPoint()));
        }
        if ((string2 = jCChart.getParam(String.valueOf(string) + ".label")) != null) {
            chartDataViewSeries.setLabel(string2);
        }
    }

    ChartConverter() {
    }
}

